<?php
/*
+------------------------------------
|   HAPPYTIME BANK MOD FOR IPB V1.2
|   Release Date: 25. Sept. 2003
+------------------------------------
*/

$idx = new Treasury;

class Treasury
{
	var $output    = "";
    var $page_title= "";
	var $nav_extra = "";
	var $base_url  = "";
	var $member    = array();
    var $nav       = array();
	    
    function Treasury() 
	{
        global $ibforums, $DB, $std, $print;

    	if (!$ibforums->member['uid']) {
 			$std->Error( array( 'LEVEL' => 1, 'MSG' => 'no_permission' ) );
  	}
    	$this->base_url = $ibforums->base_url;
		$ibforums->lang = $std->load_words($ibforums->lang, 'lang_treasury', $ibforums->lang_id );

    	$this->html = $std->load_template('skin_treasury'); 

		// initialize member data
		$this->member['id'] = $ibforums->member['uid']; 
		$this->member['name'] = $ibforums->member['uname']; 
		$this->member['money'] = $ibforums->member['money']; 
		$this->member['deposit'] = $ibforums->member['deposit']; 
		$this->member['bank_last_visit'] = $ibforums->member['bank_last_visit']; 
		$this->member['new_bank_last_visit'] = time();
		
		if ($ibforums->input['CODE'] == "") $ibforums->input['CODE'] = 00;

		switch($ibforums->input['CODE']) 
		{
    		case '00':
    			$this->splash();
    			break;
    		case '01':
    			$this->deposit();
    			break;
			case '02':
				$this->withdraw();
				break;
			case '03':
				$this->give();
				break;
			default:
				$this->splash();
				break;
		}

		// If we have any HTML to print, do so...
    	$print->add_output("$this->output");
        $print->do_output( array( 'TITLE' => $this->page_title, 'JS' => 0, NAV => $this->nav ) );
	}

 	function splash() {
 		global $ibforums, $DB, $std;

		if ($this->member['id'] == "0") {
			$std->Error( array( 'LEVEL' => 1, 'MSG' => 'no_permission' ) );
		}

		$this->member['interest'] = 0;
		$this->member['interest_days'] = 0;
		$ibforums->vars['interest_per_day'] ? $interest = $ibforums->vars['interest_per_day'] : $interest = 5;		$tmp_visit = $this->member['new_bank_last_visit'] - $this->member['bank_last_visit'];

		if ( ($this->member['bank_last_visit'] != 0) && ($tmp_visit >= 86400) ) {
			$this->member['interest_days'] = floor($tmp_visit / 86400);
			$this->member['interest'] = $this->member['interest_days'] * ( $this->member['deposit'] * (0.01*$interest));

			if ( $this->member['interest'] > 0 ) {
				$DB->query("UPDATE ibf_members SET deposit=deposit+".$this->member['interest']." WHERE uid=".$this->member['id']);
			}
		}

		if ( $tmp_visit > 3600 ) {
			$DB->query("UPDATE ibf_members SET bank_last_visit=".$this->member['new_bank_last_visit']." WHERE uid=".$this->member['id']);
		}


		$ibforums->lang['interest_info'] = str_replace( "<#NUM#>", $this->member['interest'], $ibforums->lang['interest_info'] );
		$ibforums->lang['interest_info'] = str_replace( "<#DATE#>", $this->member['interest_days'], $ibforums->lang['interest_info'] );

		$DB->query("SELECT COUNT(deposit) as total_members, SUM(deposit) as total_deposit FROM ibf_members WHERE deposit>0");
		$bank_summary = $DB->fetch_row();
		$DB->free_result();

		$DB->query("SELECT uname, deposit FROM ibf_members WHERE deposit>0 ORDER BY deposit DESC LIMIT 0, 10");
		while($row = $DB->fetch_row()) {
			$name = $row['uname'];
			$money = $row['deposit'];
	 		$t_html .= $this->html->listRichers($name, $money);		
		}
		$DB->free_result();


		$this->output .= $this->html->start();
 		$this->output .= $this->html->Page_header($this->member['interest'], $this->member['interest_days'], $this->member['deposit'], $bank_summary['total_members'], $bank_summary['total_deposit']);
		$this->output = preg_replace( "/<!-- BANKRICHERS -->/" , "$t_html" , $this->output );

		$DB->query("SELECT id, name_send, money FROM ibf_bank WHERE id_receive=".$this->member['id']." ORDER BY id DESC LIMIT 0, 10");
		while($row = $DB->fetch_row()) {
			$name = $row['name_send'];
			$money = $row['money'];
			$time = $std->get_date($row['id'], 'JOINED');
	 		$this->output .= $this->html->listLenders($name, $money, $time);		
		}
		$DB->free_result();

 		$this->output .= $this->html->listMiddle();		

		$DB->query("SELECT id, name_receive, money FROM ibf_bank WHERE id_send=".$this->member['id']." ORDER BY id DESC LIMIT 0, 10");
		while ($row = $DB->fetch_row()) {
			$name = $row['name_receive'];
			$money = $row['money'];
			$time = $std->get_date($row['id'], 'JOINED');
			$this->output .= $this->html->listBorrowers($name, $money, $time);
		}
		$DB->free_result();
		
		$this->output .= $this->html->end();  

 		$this->page_title = $ibforums->lang['page_title'];
 		$this->nav        = array( $ibforums->lang['page_title'] );
 		
 	}

	function deposit() {
		global $ibforums, $DB, $std, $HTTP_POST_VARS, $INFO;

		$amount = $HTTP_POST_VARS['amount'];
		if  ($amount <= 0) {
			$this->output .= $this->html->deposit_error(1);
			$this->splash();
		} elseif  ($this->member['money'] < $amount) {
			$this->output .= $this->html->deposit_error(2);
			$this->splash();
		} else {
			$DB->query("update ibf_members SET money=money-{$amount} where uid = {$this->member['id']}");
			$DB->query("update ibf_members SET deposit=deposit+{$amount} where uid = {$this->member['id']}");
			$std->boink_it($ibforums->vars['board_url']."/index.{$ibforums->vars['php_ext']}?act=Treasury");
		}
	}

	function withdraw() {
		global $ibforums, $DB,$std,$HTTP_POST_VARS, $INFO;
	
		$amount = $HTTP_POST_VARS['amount'];
		if  ($amount <= 0) {
			$this->output .= $this->html->withdraw_error(1);
			$this->splash();
		} elseif  ($this->member['deposit'] < $amount) {
			$this->output .= $this->html->withdraw_error(2);
			$this->splash();
		} else {
			$DB->query("update ibf_members SET money=money+{$amount} where uid = {$this->member['id']}");
			$DB->query("update ibf_members SET deposit=deposit-{$amount} where uid = {$this->member['id']}");
			$std->boink_it($ibforums->vars['board_url']."/index.{$ibforums->vars['php_ext']}?act=Treasury");
		}
	}

	function give() {
		global $ibforums, $REQUEST_METHOD, $DB,$std,$HTTP_POST_VARS, $INFO;

		$friendname = $HTTP_POST_VARS['friendname'];
		$amount = $HTTP_POST_VARS['amount'];
		$nameExist=0;

		$res = $DB->query("SELECT count(name) FROM `ibf_members` where uname='{$friendname}'");

		// is receiver exist 
		if (mysql_result($res,0,"count(name)") == 0)
			$nameexist = 1;				
		
		if ($nameexist==1) {
			$this->output .= $this->html->give_error(1);
			$this->splash();
		} else {
			if ($amount <= 0) {
				$this->output .= $this->html->give_error(2);
				$this->splash();
			} elseif ($this->member['deposit'] < $amount) {
				$this->output .= $this->html->give_error(3);
				$this->splash();
			} else {
				$DB->query("update ibf_members SET deposit=deposit+{$amount} where uname = '{$friendname}'");
				$DB->query("update ibf_members SET deposit=deposit-{$amount} where uid = {$this->member['id']}");

				$DB->query("SELECT uid FROM ibf_members WHERE uname='{$friendname}'");
				while ($row = $DB->fetch_row() ) {
					$id_rev = $row['uid'];
					break;
				}
				$DB->free_result();

				$DB->query("SELECT uname FROM ibf_members WHERE uid='{$this->member['id']}'");
				while ($row = $DB->fetch_row() ) {
					$nme_send = $row['uname'];
					break;
				}
				$DB->free_result();

				$timepost = time();
				if ($this->member['id'] != $id_rev) {
					$DB->query("INSERT INTO ibf_bank (id,id_send,name_send,id_receive,name_receive,money) VALUES ($timepost,{$this->member['id']},'$nme_send',{$id_rev}, '$friendname',$amount)");
				}
				$std->boink_it($ibforums->vars['board_url']."/index.{$ibforums->vars['php_ext']}?act=Treasury");
			}
		}		
	}


}
?>